﻿
// OPOS_PrinterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "OPOS_Printer.h"
#include "OPOS_PrinterDlg.h"
#include "afxdialogex.h"
#include "OposPtr.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()
// COPOS_PrinterDlg dialog


COPOS_PrinterDlg::COPOS_PrinterDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(COPOS_PrinterDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void COPOS_PrinterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_POSPRINTER1, m_opos);
	DDX_Control(pDX, IDC_LIST1, m_log);
	DDX_Control(pDX, IDC_EDIT1, inputtextbox);
}

BEGIN_MESSAGE_MAP(COPOS_PrinterDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, &COPOS_PrinterDlg::PrintTicket)
	ON_BN_CLICKED(IDC_BUTTON2, &COPOS_PrinterDlg::PrintReceipt)
	ON_BN_CLICKED(IDC_BUTTON3, &COPOS_PrinterDlg::ReportStatus)
	ON_BN_CLICKED(IDC_BUTTON4, &COPOS_PrinterDlg::ReportCapability)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON6, &COPOS_PrinterDlg::CutPaper)
	ON_BN_CLICKED(IDC_BUTTON7, &COPOS_PrinterDlg::PrintBitmap)
	ON_BN_CLICKED(IDC_BUTTON8, &COPOS_PrinterDlg::PrintBarcode)
	ON_BN_CLICKED(IDC_BUTTON9, &COPOS_PrinterDlg::OnBnClickedButton9)
	ON_BN_CLICKED(IDC_BUTTON5, &COPOS_PrinterDlg::OnBnClickedButton5)
	ON_BN_CLICKED(IDC_BUTTON10, &COPOS_PrinterDlg::OnBnClickedButton10)
	ON_BN_CLICKED(IDC_BUTTON11, &COPOS_PrinterDlg::OnBnClickedButton11)
END_MESSAGE_MAP()


BOOL COPOS_PrinterDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	GetDlgItem(IDC_BUTTON1)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON2)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON3)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON4)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON5)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON6)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON7)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON8)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON9)->EnableWindow(false);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void COPOS_PrinterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void COPOS_PrinterDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR COPOS_PrinterDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

typedef struct tITEMDATA {
	long Price;
	CString Name;
}ITEMDATA;

void COPOS_PrinterDlg::PrintTicket()
{
	double Kakaku;
	ITEMDATA idBuf[5];
	CString	ESC = L"\x1b";
	CString fDate;
	CString BcData;
	CString sBuf;
	CString sPrice;
	CString sSpace;
	int LineChars = m_opos.get_RecLineChars();

	m_log.ResetContent();
	m_log.InsertString(0, L"Print Ticket");

// Initialization
	CTime t = CTime::GetCurrentTime();
	fDate = t.Format(L"%B %d, %Y  %p %I:%M");
	BcData = L"4902720005074";

// Make a data of the buying goods
	idBuf[0].Name = L"apples";	idBuf[0].Price = 10;
	idBuf[1].Name = L"grapes";	idBuf[1].Price = 20;
	idBuf[2].Name = L"bananas";	idBuf[2].Price = 30;
	idBuf[3].Name = L"lemons";	idBuf[3].Price = 40;
	idBuf[4].Name = L"oranges";	idBuf[4].Price = 50;

	//Bitmap
	m_opos.PrintBitmap(PTR_S_RECEIPT, L"test.bmp", PTR_BM_ASIS, PTR_BM_CENTER);

//	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|1B");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + L"123xxstreet,xxxcity,xxxxstate \n");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|rA" + L"TEL 9999-99-9999   C#2\n");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|200uF");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|cA" + fDate + L"\n");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|500uF");

    int iRCharSize = LineChars-3;
	Kakaku = 0.0;

	for( int i = 0; i < 5; i++ ) {
		sBuf = idBuf[i].Name;
		Kakaku += idBuf[i].Price;
		sPrice.Format(L"$%.2f", (double)idBuf[i].Price );
		sSpace = CString(L' ', iRCharSize - (sBuf.GetLength() + sPrice.GetLength()));
		m_opos.PrintNormal( PTR_S_RECEIPT, sBuf + sSpace + sPrice + L"\n");
	}
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|200uF");

//Print the total cost
	sBuf = L"Before adding tax";
	sPrice.Format(L"$%.2f", Kakaku );
	sSpace = CString(L' ', iRCharSize - (sBuf.GetLength() + sPrice.GetLength()));
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|bC" + sBuf + sSpace + sPrice + L"\n");
	sBuf = L"tax   5.0%";
	sPrice.Format(L"$%.2f", Kakaku * 0.05 );
	sSpace = CString(L' ', iRCharSize - (sBuf.GetLength() + sPrice.GetLength()));
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + ESC + L"|uC" + sBuf + sSpace + sPrice + L"\n");
	sBuf = L"total";
	sPrice.Format(L"$%.2f", Kakaku * 1.05 );
	sSpace = CString(L' ', iRCharSize / 2 - (sBuf.GetLength() + sPrice.GetLength()));
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + ESC + L"|bC" + ESC + L"|2C" + sBuf + sSpace + sPrice + L"\n");
	sBuf = L"Customer's payment";
	sPrice.Format(L"$%.2f", 200.0 );
	sSpace = CString(L' ', iRCharSize - (sBuf.GetLength() + sPrice.GetLength()));
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + sBuf + sSpace + sPrice + L"\n");
	sBuf = L"Change";
	sPrice.Format(L"$%.2f", 200 - Kakaku * 1.05 );
	sSpace = CString(L' ', iRCharSize - (sBuf.GetLength() + sPrice.GetLength()));
	m_opos.PrintNormal( PTR_S_RECEIPT, sBuf + sSpace + sPrice + L"\n");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|300uF");

	m_opos.PrintBarCode( PTR_S_RECEIPT, BcData, PTR_BCS_JAN13, 70, 5, PTR_BC_CENTER, PTR_BC_TEXT_BELOW );
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|1000uF");
	m_opos.CutPaper( 75 );
}

void COPOS_PrinterDlg::PrintReceipt()
{
	int LineChars = m_opos.get_RecLineChars();
	CString ESC = L"\x1b";
	CString fDate;
	CString BcData;
		
	m_log.ResetContent();
	m_log.InsertString(0, L"Print Receipt");

// Initialization
	CTime t = CTime::GetCurrentTime();
	fDate = t.Format(L"%B %d, %Y  %p %I:%M");
	BcData = L"4902720005074";

	//Rotate 90
	m_opos.RotatePrint( PTR_S_RECEIPT, PTR_RP_LEFT90);
	m_opos.PrintBitmap( PTR_S_RECEIPT, L"test.bmp", PTR_BM_ASIS, PTR_BM_CENTER);

	if(LineChars==48) // for 3"
	{
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|350uF");
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|4C" + ESC + L"|bC   Receipt/收據     ");
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + ESC + L"|3C" + ESC + L"|2uC       Mr. Brawn\n");
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|2uC                                                  \n");
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|100uF");
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + ESC + L"|2uC" + ESC + L"|3C        Total payment              $" + ESC + L"|4C21.00  ");
	}
	else // for 2"
	{
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|100uF");
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|bC   Receipt/收據     ");
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N                  " + ESC + L"|2uCMr. Brawn\n");		
		m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + ESC + L"|2uC        Total payment              $21.00  ");
	}
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|10uF");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|1C" + L"\n");
	m_opos.PrintNormal( PTR_S_RECEIPT, fDate + L" Received\n\n");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|uC Detais               \n");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + ESC + L"|1C                          " + ESC + L"|2COPOS Store\n");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|1C");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|uC Tax excluded    $20.00\n");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + ESC + L"|1C                          " + ESC + L"|bCZip code 999-9999\n");
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|N" + ESC + L"|uC Tax(5%)        $1.00" + ESC + L"|N    Phone#(9999)99-9998\n\n");
	m_opos.PrintBarCode( PTR_S_RECEIPT, BcData, PTR_BCS_JAN13, 40, 2, PTR_BC_RIGHT, PTR_BC_TEXT_BELOW );
	m_opos.RotatePrint( PTR_S_RECEIPT, PTR_RP_NORMAL );
	m_opos.CutPaper(75);
}

void COPOS_PrinterDlg::ReportStatus()
{
	m_log.ResetContent();
	int cx =0;
	long val;
	CString str_;
	m_log.ResetContent();
	
	val = m_opos.get_ServiceObjectVersion();
	str_.Format(L"Version:%d", val);
	m_log.InsertString(cx++, str_);

	str_.Format(L"HealthText:%s", m_opos.get_CheckHealthText());
	m_log.InsertString(cx++, str_);

	str_.Format(L"SODescription:%s", m_opos.get_ServiceObjectDescription());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"DeviceDescription:%s", m_opos.get_DeviceDescription());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"DeviceName:%s", m_opos.get_DeviceName());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CODescription:%s", m_opos.get_ControlObjectDescription());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"COVersion:%d", m_opos.get_ControlObjectVersion());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"SOVersion:%d", m_opos.get_ServiceObjectVersion());	
	m_log.InsertString(cx++, str_);
	
	m_log.InsertString(cx++, L"--------------------------------");

	str_.Format(L"AsyncMode:%d", m_opos.get_AsyncMode());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CharacterSet:%d", m_opos.get_CharacterSet());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CharacterSetList:%s", m_opos.get_CharacterSetList());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"ErrorStation:%d", m_opos.get_ErrorStation());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"FlagWhenIdle:%d", m_opos.get_FlagWhenIdle());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"MapMode:%d", m_opos.get_MapMode());	
	m_log.InsertString(cx++, str_);

	m_log.InsertString(cx++, L"--------------------------------");
	
	str_.Format(L"RecEmpty:%d", m_opos.get_RecEmpty());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"RecLetterQuality:%d", m_opos.get_RecLetterQuality());	
	m_log.InsertString(cx++, str_);
	
	str_.Format(L"RecLineChars:%d", m_opos.get_RecLineChars());	
	m_log.InsertString(cx++, str_);
	
	str_.Format(L"RecLineCharsList:%s", m_opos.get_RecLineCharsList());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"RecLineHeight:%d", m_opos.get_RecLineHeight());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"RecLineSpacing:%d", m_opos.get_RecLineSpacing());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"RecLinesToPaperCut:%d", m_opos.get_RecLinesToPaperCut());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"RecLineWidth:%d", m_opos.get_RecLineWidth());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"RecSidewaysMaxChars:%d", m_opos.get_RecSidewaysMaxChars());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"RecSidewaysMaxLines:%d", m_opos.get_RecSidewaysMaxLines());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"RecCartridgeState:%d", m_opos.get_RecCartridgeState());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"RecCurrentCartridge:%d", m_opos.get_RecCurrentCartridge());	
	m_log.InsertString(cx++, str_);

	m_log.InsertString(cx++, L"--------------------------------");
	
	str_.Format(L"RotateSpecial:%d", m_opos.get_RotateSpecial());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"PowerNotify:%d", m_opos.get_PowerNotify());	
	m_log.InsertString(cx++, str_);
	
	str_.Format(L"PowerState:%d", m_opos.get_PowerState());	
	m_log.InsertString(cx++, str_);
	
	str_.Format(L"MapCharacterSet:%d", m_opos.get_MapCharacterSet());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"PageModeDescriptor:%d", m_opos.get_PageModeDescriptor());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"PageModeHorizontalPosition:%d", m_opos.get_PageModeHorizontalPosition());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"PageModePrintDirection:%d", m_opos.get_PageModePrintDirection());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"PageModeStation:%d", m_opos.get_PageModeStation());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"PageModeVerticalPosition:%d", m_opos.get_PageModeVerticalPosition());	
	m_log.InsertString(cx++, str_);
}

void COPOS_PrinterDlg::ReportCapability()
{
	m_log.ResetContent();
	int cx =0;
	CString str_;
	m_log.ResetContent();
	str_.Format(L"CapCoverSensor:%d", m_opos.get_CapCoverSensor());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRec2Color:%d", m_opos.get_CapRec2Color());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecBarCode:%d", m_opos.get_CapRecBarCode());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecBitmap:%d", m_opos.get_CapRecBitmap());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecBold:%d", m_opos.get_CapRecBold());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecDhigh:%d", m_opos.get_CapRecDhigh());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecDwide:%d", m_opos.get_CapRecDwide());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecDwideDhigh:%d", m_opos.get_CapRecDwideDhigh());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecEmptySensor:%d", m_opos.get_CapRecEmptySensor());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecItalic:%d", m_opos.get_CapRecItalic());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecLeft90:%d", m_opos.get_CapRecLeft90());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecNearEndSensor:%d", m_opos.get_CapRecNearEndSensor());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecPapercut:%d", m_opos.get_CapRecPapercut());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecPresent:%d", m_opos.get_CapRecPresent());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecRight90:%d", m_opos.get_CapRecRight90());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecRotate180:%d", m_opos.get_CapRecRotate180());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecStamp:%d", m_opos.get_CapRecStamp());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecUnderline:%d", m_opos.get_CapRecUnderline());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapCharacterSet:%d", m_opos.get_CapCharacterSet());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapTransaction:%d", m_opos.get_CapTransaction());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecCartridgeSensor:%d", m_opos.get_CapRecCartridgeSensor());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecColor:%d", m_opos.get_CapRecColor());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecMarkFeed:%d", m_opos.get_CapRecMarkFeed());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CartridgeNotify:%d", m_opos.get_CartridgeNotify());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapMapCharacterSet:%d", m_opos.get_CapMapCharacterSet());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapStatisticsReporting:%d", m_opos.get_CapStatisticsReporting());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapUpdateStatistics:%d", m_opos.get_CapUpdateStatistics());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapCompareFirmwareVersion:%d", m_opos.get_CapCompareFirmwareVersion());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapUpdateFirmware:%d", m_opos.get_CapUpdateFirmware());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapConcurrentPageMode:%d", m_opos.get_CapConcurrentPageMode());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"CapRecPageMode:%d", m_opos.get_CapRecPageMode());	
	m_log.InsertString(cx++, str_);
}

void COPOS_PrinterDlg::OnClose()
{
	m_opos.put_DeviceEnabled(false);
	m_opos.ReleaseDevice();	
	m_opos.Close();
	CDialogEx::OnClose();
}

void COPOS_PrinterDlg::CutPaper()
{
	CString	ESC = L"\x1b";
	m_log.ResetContent();
	m_log.InsertString(0, L"Cut Paper");
	
	//m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|4C" + ESC + L"|bC Feed & Cut\n");
	//m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|5fP"); // feed & cut
	m_opos.CutPaper(75); // Partial Cut
	//m_opos.CutPaper(100); // Full Cut
}

void COPOS_PrinterDlg::PrintBitmap()
{
	int cx = 0;
	CString	ESC = L"\x1b";
	m_log.ResetContent();
	// PrintBitmap
	m_log.InsertString(cx++, L"Print Bitmap");	
	m_opos.PrintNormal( PTR_S_RECEIPT, L"Print Bitmap\n");
	m_opos.PrintBitmap(PTR_S_RECEIPT, L"test.bmp", PTR_BM_ASIS, PTR_BM_CENTER);
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|700uF");
	
	// PrintMemoryBitmap
	CString str_;
	BOOL		bRet;
	CFile		BitmapFile;
	CString		strBitmapData;
	BYTE		byBuffer;
	CString 	sRC;
	CString 	sRCE;
	
	bRet = BitmapFile.Open(L"test.bmp", CFile::modeRead); // Read bitmap file
	if (bRet == FALSE) {
		MessageBox(L"Cannot open bitmap file.");
		return;
	}
	
	strBitmapData.Empty();
	while (BitmapFile.Read(&byBuffer, sizeof(BYTE)) == sizeof(BYTE))
	{
		strBitmapData += TCHAR(0x30 + ((byBuffer >> 4) & 0x0F));
		strBitmapData += TCHAR(0x30 + (byBuffer & 0x0F));
	}

	BitmapFile.Close();
	m_opos.put_BinaryConversion(OPOS_BC_NIBBLE);	
	m_opos.PrintNormal( PTR_S_RECEIPT, L"PrintMemoryBitmap\n");
	str_.Format(L"PrintMemoryBitmap:%d",m_opos.PrintMemoryBitmap(PTR_S_RECEIPT, strBitmapData, PTR_BMT_BMP,
							PTR_BM_ASIS, PTR_BM_CENTER));
	m_log.InsertString(cx++, str_);
	m_opos.put_BinaryConversion(OPOS_BC_NONE);
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|700uF");
	
	// SetBitmap
	str_.Format(L"SetBitmap(NO.1,CENTER):%d",m_opos.SetBitmap(1,PTR_S_RECEIPT,L"test.bmp",PTR_BM_ASIS,PTR_BM_CENTER));	
	m_log.InsertString(cx++, str_);
	str_.Format(L"SetBitmap(NO.2,LEFT):%d",m_opos.SetBitmap(2,PTR_S_RECEIPT,L"test.bmp",PTR_BM_ASIS,PTR_BM_LEFT));
	m_log.InsertString(cx++, str_);
	m_opos.PrintNormal( PTR_S_RECEIPT, L"Print SetBitmap(NO.1,CENTER)\n");
	str_.Format(L"Print SetBitmap(NO.1,CENTER):%d",	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|1B"));
	m_log.InsertString(cx++, str_);
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|700uF");
	m_opos.PrintNormal( PTR_S_RECEIPT, L"Print SetBitmap(NO.2,LEFT)\n");
	str_.Format(L"Print SetBitmap(NO.2,LEFT):%d",	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|2B"));
	m_log.InsertString(cx++, str_);
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|700uF");
	m_opos.CutPaper(75);

}

void COPOS_PrinterDlg::PrintBarcode()
{
	CString	ESC = L"\x1b";
	CString BcData;
	BcData= L"4902720005074";
	m_log.ResetContent();
	m_log.InsertString(0, L"Print BarCode");
	m_opos.PrintBarCode( PTR_S_RECEIPT, BcData, PTR_BCS_JAN13, 70, 6, PTR_BC_CENTER, PTR_BC_TEXT_BELOW );
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|700uF");
	m_log.InsertString(0, L"Print QRCode");
	m_opos.PrintBarCode( PTR_S_RECEIPT, BcData, PTR_BCS_QRCODE, 6, 100, PTR_BC_CENTER, PTR_BC_TEXT_BELOW );	// QR Code only use width
	m_opos.PrintNormal( PTR_S_RECEIPT, ESC + L"|700uF");
	m_opos.CutPaper(75);
}


void COPOS_PrinterDlg::OnBnClickedButton9()
{
	CString cstrData;

	inputtextbox.GetWindowTextW(cstrData);
	m_opos.PrintNormal( PTR_S_RECEIPT, cstrData+L"\n\n\n");
}


void COPOS_PrinterDlg::OnBnClickedButton5()
{
	m_log.ResetContent();
	int cx =0;
	long val=0;
	CString str_;
	CString cstrData;
	m_log.ResetContent();
	
	str_.Format(L"Cover Open:%d", m_opos.get_CoverOpen());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"Paper NearEnd:%d", m_opos.get_RecNearEnd());	
	m_log.InsertString(cx++, str_);

	str_.Format(L"Paper Empty:%d", m_opos.get_RecEmpty());	
	m_log.InsertString(cx++, str_);

}
BEGIN_EVENTSINK_MAP(COPOS_PrinterDlg, CDialogEx)
	ON_EVENT(COPOS_PrinterDlg, IDC_POSPRINTER1, 2, COPOS_PrinterDlg::DirectIOEventPosprinter1, VTS_I4 VTS_PI4 VTS_PBSTR)	
	ON_EVENT(COPOS_PrinterDlg, IDC_POSPRINTER1, 3, COPOS_PrinterDlg::ErrorEventPosprinter1, VTS_I4 VTS_I4 VTS_I4 VTS_PI4)
	ON_EVENT(COPOS_PrinterDlg, IDC_POSPRINTER1, 4, COPOS_PrinterDlg::OutputCompleteEventPosprinter1, VTS_I4)
	ON_EVENT(COPOS_PrinterDlg, IDC_POSPRINTER1, 5, COPOS_PrinterDlg::StatusUpdateEventPosprinter1, VTS_I4)
END_EVENTSINK_MAP()

void COPOS_PrinterDlg::DirectIOEventPosprinter1(long EventNumber, long* pData, BSTR* pString)
{
	// TODO: Add your message handler code here
}

void COPOS_PrinterDlg::ErrorEventPosprinter1(long ResultCode, long ResultCodeExtended, long ErrorLocus, long* pErrorResponse)
{
	long	lRet;
	CString sRC;
	CString sRCE;

	sRC.Format(L"ResultCode = %ld\n", ResultCode );
	sRCE.Format(L"ResultCodeExtended = %ld\n", ResultCodeExtended );
	lRet = MessageBox(L"Printer Error.\n\n" + sRC + sRCE, L"ErrorEvent", MB_ICONINFORMATION | MB_RETRYCANCEL );
	if( lRet == IDCANCEL )
	{
		*pErrorResponse = OPOS_ER_CLEAR;
	}
}

void COPOS_PrinterDlg::OutputCompleteEventPosprinter1(long OutputID)
{
	MessageBox(L"Complete printing", L"OutputCompleteEvent", MB_ICONINFORMATION );
}

void COPOS_PrinterDlg::StatusUpdateEventPosprinter1(long Data)
{
    static BOOL bRecEnb = TRUE;
	static BOOL bStatePaper = TRUE;
	static BOOL bStateCover = TRUE;
	static BOOL bCoverSensor = TRUE;
	CString str_;
	m_log.ResetContent();
	//Make messages for the each event information.

	switch( Data )
	{
	case PTR_SUE_COVER_OPEN:        // Printer cover is open.
		bStateCover = FALSE;		
		m_log.InsertString(0, L"Printer cover is open!");
		break;
    case PTR_SUE_REC_EMPTY:			// No receipt paper.
        bStatePaper = FALSE;
		m_log.InsertString(0, L"Printer paper is empty!");
		break;
    case PTR_SUE_COVER_OK:			// Printer cover is close.
        bStateCover = TRUE;
		m_log.InsertString(0, L"Printer cover is close!");
		break;
    case PTR_SUE_REC_PAPEROK:		// Receipt paper is ok.
		bStatePaper = TRUE;
		m_log.InsertString(0, L"Printer paper is ready!");
		break;
    case PTR_SUE_REC_NEAREMPTY:		// Receipt paper is ok.(Near Empty)
        bStatePaper = TRUE;
		m_log.InsertString(0, L"Printer paper is near end!");
		break;
	default:
		str_.Format(L"Un-define event:0x%x",Data);	
		m_log.InsertString(0, str_);
	}

	if( bStatePaper && ( bStateCover || !bCoverSensor ) )
	{
        bRecEnb = TRUE;
		m_log.InsertString(0, L"Printer is ready for printing.");
	}else
	{
        bRecEnb = FALSE;
		m_log.InsertString(0, L"Printer is not ready.");
	}
}


void COPOS_PrinterDlg::OnBnClickedButton10()
{
	long val;
	int cx=0;
	CString str_;
	
	m_log.ResetContent();
	val = m_opos.Open(L"RTPSO");
	str_.Format(L"Open:%d",val);
	m_log.InsertString( cx++, str_);
	if(val)
		return;

	val = m_opos.ClaimDevice(1000);
	str_.Format(L"Claim:%d",val);
	m_log.InsertString( cx++, str_);
	if(val)
		return;

	m_opos.put_DeviceEnabled(true);
	m_log.InsertString( cx++, L"Device:Enable");
	
	
	val = m_opos.CheckHealth(1);
	str_.Format(L"Health:%d",val);
	m_log.InsertString( cx++, str_);

	str_.Format(L"HealthText:%s", m_opos.get_CheckHealthText());
	m_log.InsertString( cx++, str_);
	if(val)
		return;

	GetDlgItem(IDC_BUTTON10)->EnableWindow(false);
	GetDlgItem(IDC_BUTTON1)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON2)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON3)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON4)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON5)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON6)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON7)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON8)->EnableWindow(true);
	GetDlgItem(IDC_BUTTON9)->EnableWindow(true);
	
}


void COPOS_PrinterDlg::OnBnClickedButton11()
{
	long val;
	int cx=0;
	CString str_;

	m_log.ResetContent();
	val = m_opos.ClaimDevice(1000);
	str_.Format(L"Claim:%d",val);
	m_log.InsertString( cx++, str_);
	m_opos.put_FreezeEvents(FALSE);
}


